//
// OrderedList.java
//
//	Numbered list.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;
import java.awt.*;
import java.text.*;

/**
 * OrderedList displays a number next to each item.  This
 * implementation makes no attempt to allocate extra space if the
 * number bullets are bigger than the indent width.
 */
class OrderedList extends List {

    /**
     * Construct an Ordered list.
     * 
     * @param state Graphics parameters.
     * @param factory Gives us tokens.
     * @param indent indent level (used in draw).
     */
    OrderedList(GraphicsState state, TokenFactory factory, int indent) {
	super(state, factory, indent);
    }

    /**
     * Draw the bullet for an ordered list.  For ordered lists we draw
     * numbers.
     * 
     * @param state Graphics parameters.
     * @param top Top of bullet.
     * @param itemNum Number of this item.
     */
    void drawBullet(GraphicsState state, int top, int itemNum) {
	String bullet = MessageFormat.format(
	    state._listNumberFormat,
	    new Integer[] { new Integer(itemNum) });
	int width = state._plainFontMetrics.stringWidth(bullet);
	Font saveFont = state._graphics.getFont();
	state._graphics.setFont(state._plainFont);
	state._graphics.drawString(bullet,
				   _x + state._indentWidth - width,
				   top + state._plainFontMetrics.getAscent());
	state._graphics.setFont(saveFont);
    }
}
