//
// SingleWord.java
//
//	A single word of text in a RichText component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;

/**
 * SingleWord represents a string of characters that are all to be
 * drawn with the same font.  A SingleWord object may or may not end
 * in a space (spaces are drawn by words); if a word in the written
 * language sense is drawn with multiple fonts it will have to be
 * represented by more than one SingleWord.
 */
class SingleWord extends Word {
    private String _text;

    /**
     * Construct a SingleWord.
     * 
     * @param text The text of the word.
     */
    SingleWord(String text) {
	_text = text;
    }

    /**
     * Set the geometry of a word.
     * 
     * @param state Graphics parameters.
     * @param x horizontal position.
     * @param y vertical position.
     * @param height height.
     */
    void setGeometry(GraphicsState state, int x, int y, int height) {
	_x = x;
	_y = y;

	_width = state._fontMetrics.stringWidth(_text);
	_height = height;
    }

    /**
     * Draw a word.
     * 
     * @param state Graphics parameters.
     */
    void draw(GraphicsState state) {
	// Use _plainFontMetrics for all fonts, because we want to use
	// the same baseline for all our fonts.
	int y = _y + state._plainFontMetrics.getAscent();

	state._graphics.drawString(_text, _x, y);

	if (state._inLink && state._underlineLinks) {
	    state._graphics.drawLine(_x, y + 1, _x + _width, y + 1);
	}
    }

    /**
     * See if (<tt>x</tt>, <tt>y</tt>) intersects this word.
     * 
     * @param x horizontal position.
     * @param y vertical position.
     * 
     * @return true if (<tt>x</tt>, <tt>y</tt>) intersects, false
     *         otherwise.
     */
    boolean intersects(int x, int y) {
	return _x <= x && x <= _x + _width && _y <= y && y <= _y + _height;
    }
}
