//
// UnorderedList.java
//
//	Unordered list of items within a RichText component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;

import java.awt.*;

/**
 * UnorderedList displays a graphical bullet next to each item.
 */
class UnorderedList extends List {

    /**
     * Construct an UnorderedList.
     * 
     * @param state Graphics parameters.
     * @param factory Gives us tokens.
     * @param indent indent level (used in draw).
     */
    UnorderedList(GraphicsState state, TokenFactory factory, int indent) {
	super(state, factory, indent);
    }

    /**
     * Draw a bullet in front of a list item.  Level 1 gets a filled
     * circle, level 2 gets a circle outline, and levels 3 and beyond
     * get rectangle outlines.
     * 
     * @param state Graphics parameters.
     * @param top Top of bullet.
     * @param itemNum Number of this item.
     */
    void drawBullet(GraphicsState state, int top, int itemNum) {
	// I tried using the symbol characters that start at 0x2700 in
	// Unicode, but unfortunately the characters are much
	// different on NT than they are on Irix.  Same story with the
	// "ZapfDingbats" font.
	//
	// The approach I have taken here has the disadvantage that it
	// cannot be customized.  It has the advantage that it looks
	// almost identical on Irix and NT.
	// 	--rogerc
	int x = _x + state._bulletLeftOffset;
	int width = state._plainFontMetrics.charWidth('o');
	int height = width;
	int y = top + state._bulletTopOffset
	    + state._plainFontMetrics.getLeading()
	    + (state._plainFontMetrics.getAscent() - height) / 2;
	if (_indent == 0) {
	    state._graphics.fillOval(x, y, width, height);
	} else if (_indent == 1) {
	    state._graphics.drawOval(x, y, width - 1, height - 1);
	} else {
	    state._graphics.drawRect(x, y, width - 1, height - 1);
	}
    }
}
