//
// Word.java
//
//	Base class for words in a RichText component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.richText;

/**
 * Abstract base class for words.
 */
abstract class Word extends RectObj {

    /**
     * Set the geometry of this Word.  Base class has 0 width.
     * 
     * @param state Graphics state.
     * @param x horizontal position.
     * @param y vertical position.
     * @param height height.
     */
    void setGeometry(GraphicsState state, int x, int y, int height) {
	_x = x;
	_y = y;
	_width = 0;
	_height = height;
    }

    /**
     * See if (<tt>x</tt>, <tt>y</tt>) intersects this word.  Base
     * class returns false because some derived classes such as
     * FontChange and EndLink should never return true.
     * 
     * @param x horizontal coordinate.
     * @param y vertical coordinate.
     * 
     * @return true if (<tt>x</tt>, <tt>y</tt>) intersects, false
     *         otherwise.
     */
    boolean intersects(int x, int y) {
	return false;
    }

    /**
     * Subclasses override this to draw themselves.
     * 
     * @param state Graphics parameters.
     */
    abstract void draw(GraphicsState state);
}    
