//
// AssociationItemFinderBinder.java
//
//	Bind String task data to a Association.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import com.sgi.sysadm.category.*;
import com.sgi.sysadm.ui.*;

/**
 * AssociationItemFinderBinder sets the association used to
 * populate an item finder based on whether a taskData attribute
 * is the empty string or not. This attribute is the parent
 * selector for the association.
 */
public class AssociationItemFinderBinder extends TaskDataBinder {

    private ItemFinder _itemFinder;
    private String _parent;
    private String _child;
    private HostContext _hc;

    /**
     * Construct a AssociationItemFinderBinder.
     *
     * @param itemfinder ItemFinder to keep consistent with task data.
     * @param parent     String name of the Parent Category
     *                   needed for the association.
     * @param child      String name of the Child Category
     *                   needed for the association.
     * @param hc         HostContext is needed to get the association.
     */
    public AssociationItemFinderBinder(ItemFinder itemFinder,
				       String parent,
				       String child,
				       HostContext hc) {
	_itemFinder = itemFinder;
	_parent = parent;
	_child = child;
	_hc = hc;
    }

    /**
     * Bind <tt>itemfinder</tt> to the Attribute
     * <tt>parentSelectorKey</tt> in <tt>taskData</tt> so that when
     * the Attribute changes <tt>an association</tt> is updated.
     *
     * @param taskData              TaskData to bind.
     * @param parentSelectorKey     Name of Attribute to bind.
     * @param parent                String name of the Parent Category
     *                              needed for the association.
     * @param child                 String name of the Child Category
     *                              needed for the association.
     * @param itemFinder            ItemFinder
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(parentSelectorKey,
     * new AssociationItemFinderBinder(itemFinder, parent, child, hc))</CODE>
     */
    static public void bind(TaskData taskData, String parentSelectorKey,
			    String parent, String child, HostContext hc,
			    ItemFinder itemFinder) {
	taskData.
	    addTaskDataBinder(parentSelectorKey, new
			      AssociationItemFinderBinder(itemFinder,
							  parent,
							  child, hc));
    }

    /**
     * Called when our task data changes.  If the attribute that we have
     * bound to in taskData is not the empty string, then set up a new
     * association and send it to itemFinder. Else, clear itemfinder
     * category.
     *
     * @param event The taskData changed event
     */
    public void taskDataChanged(TaskDataEvent event) {
	String parentSelector =
	    event.getTaskData().getString(event.getName());
	if (parentSelector.equals("")) {
	    _itemFinder.setCategory(null);
	} else {
	    _itemFinder.setCategory( _hc.getAssociation(_parent,
							parentSelector,
							_child));
	}
    }
}
