//
// BooleanComponentEnabledBinder.java
//
//	Bind boolean task data to the enabled state of a java component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import java.awt.*;

/**
 * BooleanComponentEnabledBinder enables or disables an AWT
 * Component according to a Boolean TaskData Attribute.  The Attribute
 * does not change if the Component's enable state is changed through
 * some other mechanism.
 */
public class BooleanComponentEnabledBinder extends TaskDataBinder {
    Component _comp;

    /**
     * Construct a BooleanComponentEnabledBinder.
     *
     * @param comp Component to manage enabled state of.
     */
    public BooleanComponentEnabledBinder(Component comp) {
	_comp = comp;
    }

    /**
     * Bind the Attribute <tt>name</tt> in <tt>taskData</tt> to
     * <tt>comp</tt> so that when the Attribute changes the enabled
     * state of <tt>comp</tt> changes.  <tt>comp</tt> is not monitored
     * for changes, so if <tt>comp</tt> is enabled or disabled through
     * some other mechanism the Attribute will not be updated.
     *
     * @param taskData TaskData to bind.
     * @param name name of Attribute to bind.
     * @param comp Component to bind.
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(name,
     * new BooleanComponentEnabledBinder(comp))</CODE>
     */
    static public void bind(TaskData taskData, String name,
			    Component comp) {
	taskData.addTaskDataBinder(
	    name, new BooleanComponentEnabledBinder(comp));
    }

    /**
     * Called when our TaskData changes.
     *
     * @param event TaskDataEvent.
     */
    public void taskDataChanged(TaskDataEvent event) {
	boolean state = event.getTaskData().getBoolean(getName());
	if (state != _comp.isEnabled()) {
	    _comp.setEnabled(state);
	}
    }
}
