//
// LongRButtonGroupBinder.java
//
//	Keep long task data in sync with the buttons in a RButtonGroup.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import javax.swing.*;
import java.awt.event.*;
import com.sgi.sysadm.ui.*;

/**
 * LongRButtonGroupBinder is used to keep long task data synchronized
 * with the buttons in a RButtonGroup.
 * <p>
 * The buttons are numbered in the order they are added to the
 * RButtonGroup.
 *
 * @see RButtonGroup
 */
public class LongRButtonGroupBinder extends TaskDataBinder {

    private RButtonGroup _group;

    /**
     * Construct a LongRButtonGroupBinder.
     *
     * @param group RButtonGroup to keep synchronized.
     */
    public LongRButtonGroupBinder(RButtonGroup group) {
	_group = group;
	group.addRButtonGroupListener(
	    new RButtonGroup.RButtonGroupListener() {
	    public void selectionChanged(long selection) {
		String name = getName();
		TaskData taskData = getTaskData();
		if (taskData.getLong(name) != selection) {
		    taskData.setLong(name, selection);
		}
	    }
	});
    }

    /**
     * Bind the Attribute <tt>name</tt> in <tt>taskData</tt> to
     * <tt>group</tt>, so that when a button is selected in
     * <tt>group</tt> the Attribute is changed to match, and
     * vice versa.
     *
     * @param taskData TaskData to bind.
     * @param name name of Attribute to bind.
     * @param group RButtonGroup to bind.
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(name,
     * new LongRButtonGroupBinder(group))</CODE>
     */
    static public void bind(TaskData taskData, String name,
			    RButtonGroup group) {
	taskData.addTaskDataBinder(
	    name, new LongRButtonGroupBinder(group));
    }

    /**
     * Called when our task data changes.  Select the button in the
     * group that matches the task data attribute.
     *
     * @param event TaskDataEvent.
     */
    public void taskDataChanged(TaskDataEvent event) {
	TaskData taskData = event.getTaskData();
	String name = event.getName();
	long val = taskData.getLong(name);
	if (val != _group.getSelectedIndex()) {
	    _group.setSelectedIndex(val);
	}
    }
}
