//
// StringComponentEnabledBinder.java
//
//	Bind String task data to enabling/disabling a component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import java.awt.*;
import com.sgi.sysadm.ui.*;

/**
 * StringComponentEnabledBinder disables or enables a component
 * depending on whether a taskData attribute is the empty string
 * or not, respectively.
 */
public class StringComponentEnabledBinder extends TaskDataBinder {

    private Component _component;

    /**
     * Construct a StringComponentEnabledBinder.
     *
     * @param component Component to be enabled/disabled.
     */
    public StringComponentEnabledBinder(Component component) {
	_component = component;
    }

    /**
     * Bind <tt>component</tt> to the Attribute
     * <tt>name</tt> in <tt>taskData</tt> so that when
     * the Attribute changes <tt>the component</tt> is enabled/disabled.
     *
     * @param taskData   TaskData to bind.
     * @param name       Attribute to bind.
     * @param Component  component to enable or disable.
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(name,
     * new StringComponentEnabledBinder(component))</CODE>
     */
    static public void bind(TaskData taskData, String name,
			    Component component) {
	taskData.
	    addTaskDataBinder(name,
			      new StringComponentEnabledBinder(component));
    }

    /**
     * Called when our task data changes.  If the attribute that we have
     * bound to in taskData is not the empty string, then enable the
     * component. Else, disable it.
     *
     * @param event The taskData changed event
     */
    public void taskDataChanged(TaskDataEvent event) {
	boolean enable = true;

	if (event.getTaskData().
	    getString(event.getName()).equals("")) {
	    enable = false;
	}

	_component.setEnabled(enable);
    }
}
