//
// StringJLabelBinder.java
//
//	Bind String task data to a JLabel component.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import java.awt.Container;
import javax.swing.JLabel;

/**
 * StringJLabelBinder keeps the string displayed by a JLabel component
 * synchronized with String task data.  If the label is changed
 * independently of the task data, the task data will not be updated.
 */
public class StringJLabelBinder extends TaskDataBinder
{
    private JLabel _label;

    /**
     * Construct a StringJLabelBinder.
     *
     * @param label JLabel to keep consistent with task data.
     */
    public StringJLabelBinder(JLabel label) {
	_label = label;
    }

    /**
     * Bind <tt>label</tt> to the Attribute <tt>name</tt> in
     * <tt>taskData</tt> so that when the Attribute changes
     * <tt>label</tt> is updated.
     *
     * @param taskData TaskData to bind.
     * @param name name of Attribute to bind.
     * @param label JLabel to bind.
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(name,
     * new StringJLabelBinder(label))</CODE>
     */
    static public void bind(TaskData taskData, String name, JLabel label) {
	taskData.addTaskDataBinder(name, new StringJLabelBinder(label));
    }

    /**
     * Called when our task data changes.  Update the value of our
     * JLabel.
     *
     * @param event the TaskDataEvent.
     */
    public void taskDataChanged(TaskDataEvent event) {
	_label.setText(event.getTaskData().getString(event.getName()));
	_label.invalidate();
	Container parent = _label.getParent();
	if (parent != null) {
	    parent.doLayout();
	}
    }
}
