//
// StringTaskLaunchComponentBinder.java
//
//      A class that binds a piece of TaskData to the status message
//      of a TaskLaunchComponent
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import com.sgi.sysadm.ui.*;
/**
 * A class that binds a piece of TaskData to the status message of a
 * TaskLaunchComponent
 */
public class StringTaskLaunchComponentBinder extends TaskDataBinder {

    TaskLaunchComponent _tlc;

      /**
     * Construct a StringTaskLaunchComponentBinder
     *
     * @param tlc The TaskLaunchComponent to be bound.
     */
    public StringTaskLaunchComponentBinder(TaskLaunchComponent tlc) {
	_tlc = tlc;
    }

    /**
     * Called when our task data changes.  Set the status to the task data.
     *
     * @param event The taskData changed event
     */
    public void taskDataChanged(TaskDataEvent event) {
	_tlc.setStatus(event.getTaskData().
		       getString(event.getName()));
    }

     /**
     * Bind <tt>tlc</tt> to the Attribute
     * <tt>name</tt> in <tt>taskData</tt> so that when
     * the Attribute changes the status of the TaskLaunchComponent is
     * set
     *
     * @param taskData   TaskData to bind.
     * @param name       Attribute to bind.
     * @param tlc        The TaskLaunchComponent to bind.
     *
     * @deprecated Use <CODE>taskData.addTaskDataBinder(name,
     * new StringTaskLaunchComponentBinder(tlc))</CODE>
     */
    static public void bind(TaskData taskData, String name,
			    TaskLaunchComponent tlc) {
	taskData.
	    addTaskDataBinder(name,
			      new StringTaskLaunchComponentBinder(tlc));
    }
}
