//
// TaskData.java
//
//	Parameters within a task.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import java.util.*;
import com.sgi.sysadm.util.*;
import com.sgi.sysadm.ui.event.*;

/**
 * TaskData maintains key/value pairs representing the input to a
 * Task.  A Task accesses the data input by the user via TaskData rather
 * than through the Task Components directly in order to separate the
 * user interface of a task from the operation it represents.  This
 * facilitates providing multiple user interfaces for the same task.
 */
public class TaskData extends AttrBundle {

    /**
     * Construct TaskData with <TT>type</TT> and <TT>selector</TT>.
     *
     * @param type the type of this TaskData.
     * @param selector the selector of this TaskData.
     */
    public TaskData(String type, String selector) {
	super(type, selector);
    }

    /**
     * TaskData constructor for clients who don't care about type and
     * selector.
     */
    public TaskData() {
	super("", "");
    }

    /**
     * Add a TaskDataBinder that gets notified when a particular
     * Attribute changes.
     *
     * @param name Name of the Attribute <tt>listener</tt> cares about.
     * @param listener Gets notified when Attribute changes.
     */
    public void addTaskDataBinder(String name, TaskDataBinder binder) {
	binder.setTaskData(this, name);
	super.addAttrListener(binder);
	binder.taskDataChanged(new TaskDataEvent(this, name));
    }

    /**
     * Remove a TaskDataBinder.
     * @param binder The binder to remove.
     */
    public void removeTaskDataBinder(TaskDataBinder binder) {
	super.removeAttrListener(binder);
    }
}
