//
// TaskDataVerifier.java
//
//	Verifies one or more TaskData attributes.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.taskData;

import com.sgi.sysadm.util.*;

/**
 * TaskDataVerifier verifies one or more TaskData attributes for validity
 * and consistency.
 */
public interface TaskDataVerifier {
    /**
     * Use this as the first parameter to dataOK() if the TaskData attributes
     * do not need to be set.  In other words, null strings or zero values
     * are valid.
     *
     * @deprecated MAY_BE_EMPTY is no longer used.
     */
    public static final int MAY_BE_EMPTY = 0;
    
    /**
     * Use this as the first parameter to dataOK() if the TaskData attributes
     * must be set by the user.
     */
    public static final int MUST_BE_SET = 1;

    /**
     * Determine if the TaskData attributes associated with this verifier
     * are valid and consistent.
     * <P>
     * If the verifier fails, it should create a new ResultEvent and call
     * ResultEvent.setReason() with a localized error message.  The ResultEvent
     * should then be passed to listener.failed().
     * <P>
     * If the verifier succeeds but the user should be warned of some
     * condition, the verifier should post a warning dialog and wait to
     * call listener.succeeded() until the user confirms the dialog.
     *
     * @param browseFlag MAY_BE_EMPTY if null strings or zero values are 
     *                   valid, MUST_BE_SET if a valid value must be entered.
     * @param context An object the verifier can use to behave differently
     *                in different contexts.  The verifier must accept null
     *                for this parameter in order to be usable with the
     *                default verification process.
     * @param listener A ResultListener to be notified when the verification
     *                 succeeds or fails.
     */
    public void dataOK(int browseFlag, Object context, ResultListener listener);
}
