//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui.tests;

import javax.swing.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;
import com.sgi.sysadm.util.*;

public class AddUserGuide extends Guide {
    private TaskContext _taskContext;
    private TaskData _taskData;
    
    public AddUserGuide(TaskContext taskContext) {
	super(taskContext);
	_taskContext = taskContext; 
	_taskData = _taskContext.getTaskData();
    }
    
    public void registerPages() {
     	final ResourceStack rs = _taskContext.getResourceStack();
	
	GuidePage introPage = new GuidePage(_taskContext, "IntroPage");
	appendPage(introPage);
	
	GuidePage loginPage = new GuidePage(_taskContext, "LoginPage") {
	    public void createUI() {
		super.createUI();
		JTextField loginNameField = new JTextField(8);
		addTaskComponent(loginNameField,
				 rs.getString("LoginPage.loginNameLabel"));
		StringJTextComponentBinder.bind(_taskData, "loginName",
						  loginNameField);
	    }
	};
	
	loginPage.setVerifier(new TaskDataVerifier() {
	    public void dataOK(int browseFlag, Object context,
			       ResultListener listener) {
		_taskContext.dataOK("loginName", browseFlag, context, listener);
	    }
	});
	appendPage(loginPage);
	
	GuidePage fullNamePage = new GuidePage(_taskContext, "FullNamePage") {
	    public void createUI() {
		super.createUI();
		JTextField fullNameField = new JTextField(20);
		addTaskComponent(fullNameField,
				 rs.getString("FullNamePage.fullNameLabel"));
		StringJTextComponentBinder.bind(_taskData, "fullName",
					          fullNameField);
	    }
	};
	
	fullNamePage.setVerifier(new TaskDataVerifier() {
	    public void dataOK(int browseFlag, Object context,
			       ResultListener listener) {
		_taskContext.dataOK("fullName", browseFlag, context, listener);
	    }
	});
	appendPage(fullNamePage);

	GuidePage summaryPage = new GuidePage(_taskContext, "SummaryPage");
	appendPage(summaryPage);
    }
}



