//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui.tests;

import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;

public class AddUserTask extends Task
{
    private TaskContext _taskContext;
    private TaskData _taskData;
    private ResourceStack _rs;
    
    public AddUserTask(TaskContext taskContext) {
	super(taskContext);
	
	_taskContext = taskContext;
	_rs = _taskContext.getResourceStack();
	_taskData = _taskContext.getTaskData();
	
	// Initialize all public and private task data and add their verifiers.
	_taskData.setAttr(new Attribute("loginName", ""));
	_taskContext.appendTaskDataVerifier("loginName", new TaskDataVerifier() {
	    public void dataOK(int browseFlag, Object context,
			       final ResultListener listener) {
		
		String loginName = _taskData.getString("loginName").trim();
		if (loginName.length() == 0) {
		    if (browseFlag == TaskDataVerifier.MUST_BE_SET) {
			ResultEvent event = new ResultEvent(Task.this);
			event.setReason(_rs.getString("Error.missingLoginName"));
			listener.failed(event);
		    } else {
			listener.succeeded(new ResultEvent(this));
		    }
		    return;
		}
		
		// First check the format of the login name
		if (loginName.length() > 8) {
		    ResultEvent event = new ResultEvent(Task.this);
		    event.setReason(_rs.getString("Error.loginNameTooLong"));
		    listener.failed(event);
		    return;
		}
		
		if (loginName.indexOf(' ') > 0 || loginName.indexOf(':') >= 0) {
		    ResultEvent event = new ResultEvent(Task.this);
		    event.setReason(
			_rs.getString("Error.illegalCharInLoginName"));
		    listener.failed(event);
		    return;
		}
		
		// XXX Then check if the login name is unique
		listener.succeeded(new ResultEvent(this));
	    }
	});
	
	_taskData.setAttr(new Attribute("fullName", ""));
	_taskContext.appendTaskDataVerifier("fullName", new TaskDataVerifier() {
	    public void dataOK(int browseFlag, Object context,
			       final ResultListener listener) {
		
		String fullName = _taskData.getString("fullName").trim();
		if (fullName.length() == 0) {
		    if (browseFlag == TaskDataVerifier.MUST_BE_SET) {
			ResultEvent event = new ResultEvent(Task.this);
			event.setReason(_rs.getString("Error.missingFullName"));
			listener.failed(event);
		    } else {
			listener.succeeded(new ResultEvent(this));
		    }
		    return;
		}
		
		if (fullName.indexOf(':') >= 0) {
		    ResultEvent event = new ResultEvent(Task.this);
		    event.setReason(
			_rs.getString("Error.illegalCharInFullName"));
		    listener.failed(event);
		    return;
		}
		
		listener.succeeded(new ResultEvent(this));
	    }
	});
	
	_taskData.setAttr(new Attribute("userID", new Long(0).longValue()));
    }
    
    public void setOperands(Vector operands) throws TaskInitFailedException {
	if (operands == null || operands.size() == 0) {
	    return;
	}
	
	throw new TaskInitFailedException(
	    _rs.getString("Error.noOperandsAccepted"),
	    TaskInitFailedException.INVALID_OPERANDS);
    }
    
    public void registerInterfaces() {
	Form form = new AddUserForm(_taskContext);
	setForm(form);

	Guide guide = new AddUserGuide(_taskContext);
	setGuide(guide);
    }

    public void ok() {
	TaskData addUserTaskData = new TaskData();
	addUserTaskData.setAttr(_taskData.getAttr("loginName"));
	addUserTaskData.setAttr(_taskData.getAttr("userID"));
	try {
	    OutputStream stream = runPriv("echo", addUserTaskData);
	    OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
	    streamWriter.write(_taskData.getString("fullName"));
	    streamWriter.flush();
	    streamWriter.close();
	} catch (IOException exception) {
	    exception.printStackTrace();
	}
	
    }
    
    /**
     * Create a result panel describing the successful task completion.
     *
     * @return A JPanel describing the successful task completion if the
     *         task succeeded, null otherwise.
     */
    public ResultViewPanel createResultViewPanel() {
	return new ResultViewPanel(_taskContext,
				   _rs,
				   "com.sgi.sysadm.ui.tests.UserAccountCategory",
				   _taskData.getString("loginName"),
				   MessageFormat.format(
				       _rs.getString("AddUserTask.succeeded"),
				       new Object[]{ _taskData.getString("loginName") }
				       ));
    }
}
