//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;

class Demo extends JFrame implements ActionListener {

    TaskData _data = new TaskData();
    JButton _closeButton;

    public Demo(String title) {
	super(title);
	getContentPane().setLayout(new BorderLayout());

	_data.setString("text", "junk");
	
	JPanel panel = new JPanel();
	panel.setLayout(new GridLayout(3, 1));

	JTextField text = new JTextField(25);
	panel.add(text, "Type Here:");
	StringJTextComponentBinder.bind(_data, "text", text);

	text = new JTextField(25);
	panel.add(text, "Type Here:");
	StringJTextComponentBinder.bind(_data, "text", text);

	JLabel label = new JLabel("                                ");
	panel.add(label, "Label:");

	getContentPane().add(panel, BorderLayout.CENTER);
	
	JPanel buttonPanel = new JPanel();
	buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
	buttonPanel.add(_closeButton = new JButton("Close"));
	_closeButton.addActionListener(this);

	getContentPane().add(buttonPanel, BorderLayout.SOUTH);
	pack();

	// Add the listener after the layout's all done so that the
	// label will be wide.
	StringJLabelBinder.bind(_data, "text", label);
    }

    public void actionPerformed(ActionEvent event) {
	if (event.getSource() == _closeButton) {
	    System.exit(0);
	}
    }
    
    public static void main(String[] args) {
	Demo demo = new Demo("sysadm.ui demo");
	demo.show();
    }
}
