//
// TestApplet.java
//
//	Applet for testing
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.tests;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import javax.swing.*;
import com.sgi.sysadm.manager.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.util.*;

/**
 * TestApplet draws an icon in its rendering area.  When the user
 * clicks, TaskManager is started.
 */
public class TestApplet extends RApplet {
    private HostContext _hc;
    private static final int EXTRA_LOG_FLAGS =
        Log.WARNING | Log.INFO | Log.DEBUG | Log.TRACE;
    private FtrIcon _ftrIcon;

    public TestApplet() {
	super("com.sgi.sysadm.ui.tests.TestApplet", "com.sgi.sysadm");
    }

    /**
     * Called when we're first loaded into the browser.
     */
    public void init() {
// 	// In IE's JVM, the first invokeLater() fails, so make it one
// 	// that doesn't matter.
// 	SwingUtilities.invokeLater(new Runnable() {
// 	    public void run() {
// 	    }
// 	});

	addMouseListener(new MouseAdapter() {
	    public void mouseClicked(MouseEvent event) {
		// Shift+click starts debug logging; normal clicking
		// reverts back to just Asset/Fatal/Error logging.
		if (event.isShiftDown()) {
		    Log.levelOn(EXTRA_LOG_FLAGS);
		} else {
		    Log.levelOff(EXTRA_LOG_FLAGS);
		}
		activate();
	    }
	});
    }

    /**
     * Called when this page is displayed.  Initialize label if first
     * time.
     */
    public void start() {
	if (_ftrIcon == null) {
	    _ftrIcon = FtrIcon.createIcon("com.sgi.sysadm.ftr.Task");
	    Dimension size = getSize();
	    Insets insets = getInsets();
	    _ftrIcon.setSize(size.width - insets.left - insets.right,
			     size.height - insets.top - insets.bottom);
	    getContentPane().add(new JLabel(_ftrIcon));
	}
    }

    /**
     * Start the Task Manager.
     */
    protected RFrame launchFrame(final HostContext hc) {
	TaskManager taskManager = new TaskManager("com.sgi.sysadm.ui.tests");
	taskManager.initApp();
	RFrame frame = taskManager.getFrame();
	taskManager.run(hc, new RApp.RAppLaunchListener() {
	    public void launchSucceeded(RApp.RAppLaunchEvent event) {
	    }

	    public void launchFailed(RApp.RAppLaunchEvent event) {
		hc.exit(1);
	    }
	    
	    public void launchAlreadyRunning(RApp.RAppLaunchEvent event) {
	    }
	});
	return frame;
    }
}
