//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//
package com.sgi.sysadm.ui.tests;

import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.ui.taskData.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

class TestEditableList {

    static public void main(String args[]) {
	final TaskData taskData = new TaskData();
	taskData.setString("red", "");
	taskData.setString("green", "");
	taskData.setString("blue", "");

	JFrame frame = new JFrame();
	
	ResourceStack rs = new ResourceStack();
	rs.pushBundle(ResourceStack.getPackageName(EditableList.class) +
		      "SysadmUI" + ResourceStack.BUNDLE_SUFFIX);
	rs.pushBundle(TestEditableList.class.getName()
		      + ResourceStack.BUNDLE_SUFFIX);

	final EditableList list
	    = new EditableList("TestEditableList", rs, taskData);

	if (args.length > 0 && args[0].equals("-reorder")) {
	    list.setReorderable(true);
	}

	final JTextField red = new JTextField(10);

	JPanel editor = new JPanel(list.getEditorLayout()) {
	    public void requestFocus() {
		red.requestFocus();
	    }
	};
	    
	editor.add(red);
	StringJTextComponentBinder.bind(taskData, "red", red);
	JTextField green = new JTextField(10);
	editor.add(green);
	StringJTextComponentBinder.bind(taskData, "green", green);
	JTextField blue = new JTextField(10);
	StringJTextComponentBinder.bind(taskData, "blue", blue);
	editor.add(blue);

	initTaskData(taskData);

	list.setEditor(editor, new EditableList.DefaultEditVerifier() {
	    public void resetList(EditableList list) {
		initTaskData(taskData);
		list.updateList();
	    }
	});
// 	list.setColumns("numColors",
// 			new String[] { "red", "green", "blue" },
// 			new String[] { "Red", "Green", "Blue" });

	JPanel panel = new JPanel(new BorderLayout());
	panel.add(list, BorderLayout.CENTER);
	frame.setContentPane(panel);

	JPanel buttonPanel = new JPanel(new FlowLayout());

	JButton clearButton = new JButton("Clear");
	clearButton.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent event) {
		list.clearList();
	    }
	});
	buttonPanel.add(clearButton);

	JButton quitButton = new JButton("Quit");
	quitButton.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent event) {
		if (taskData.getBoolean("dirty")) {
		    System.out.println("Save your changes first!");
		} else {
		    System.exit(0);
		}
	    }
	});
	buttonPanel.add(quitButton);
	panel.add(buttonPanel, BorderLayout.SOUTH);

	frame.pack();
	frame.setVisible(true);
    }

    static private void initTaskData(TaskData taskData) {
	int ii;
	for (ii = 0; ii < 3; ii++) {
	    taskData.setString("red" + ii, "red" + ii);
	    taskData.setString("green" + ii, "green" + ii);
	    taskData.setString("blue" + ii, "blue" + ii);
	}
	taskData.setLong("numColors", ii);
    }
}
