//
//  Copyright (c) 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.tests;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.category.*;
import javax.swing.*;
import java.awt.Component;


public class UserAccountCategoryRenderer implements ItemTableColumnRenderer {
    public String getStringForCellOfItemTable(Item item, 
					      String attrName,
					      ItemTableContext itc) {
	//We know that the attr we need to worry about is "name"
	if (!attrName.equals(attrName)){
	    com.sgi.sysadm.util.Log.fatal
		("only expected \"name\" as the attrName.");
	}
	return item.getAttr(attrName).stringValue().toUpperCase();
    }
    
    public JComponent getComponentForCellOfItemTable(Item item, 
						     String attrName,
						     ItemTableContext itc) {
	return null;
    }

    public String getRichTextForCellOfItemTable(Item item, 
						String attrName,
						ItemTableContext itc) {
	return null;
    }
    
    public int compareItemsForItemTable(Item item1, Item item2,
					String attrName) {
	return 0;
    }
}
