//
// TreeContext.java
//
//	Global data needed by TreeView classes.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.treeView;

import com.sgi.sysadm.category.*;
import com.sgi.sysadm.ui.*;
import com.sgi.sysadm.util.*;
import javax.swing.*;
import java.util.*;
import java.awt.*;

/**
 * TreeContext encapsulates global state needed by various
 * tree-related classes in the TreeViewPane.
 *
 * @author	Roger Chickering
 * @author	John Relph
 * @version	$Revision: 1.12 $ $Date: 2000/07/24 21:58:15 $
 */
class TreeContext implements TreeViewProperties {
    ResourceStack _rs;
    HostContext _hc;
    JTree _tree;
    Item _rootItem;
    boolean _autoExpand = true;
    UIContext _uic;
    String _prefix;

    int _iconWidth;
    int _iconHeight;
 
    private String _class =
	ResourceStack.getClassName(TreeContext.class);

     /**
     * Construct a TreeContext.
     *
     * @param uic UIContext
     * @param rs ResourceStack
     * @param hc HostContext
     * @param tree JTree
     * @param rootItem The root of the tree
     * @param prefix String property prefix
     */
    TreeContext(UIContext uic, ResourceStack rs, HostContext hc,
		JTree tree, Item rootItem, String prefix) {
	_uic = uic;
	_rs = rs;
	_hc = hc;
	_tree = tree;
	_rootItem = rootItem;
	_prefix = prefix;

	_iconWidth = _rs.getPixels(propNames(ICON_WIDTH));
	_iconHeight = _rs.getPixels(propNames(ICON_HEIGHT));
    }

    private String[] propNames(String resource) {
	return new String[] {
	    _prefix + resource,
	    TREEVIEWPANE_PROPERTY_PREFIX + resource
	};
    }
}
