//
// TreeViewProperties.java
//
//	Interface that contains all of the properties used to
//	customize the TreeView.
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.ui.treeView;

/**
 * <P>TreeViewProperties is an interface that contains all of the
 * properties used to customize the TreeView and its supporting
 * classes.  Classes that wish access to the TreeView properties
 * should implement this interface.</P>
 * <P>These property names are usually appended to the <I>prefix</I> passed
 * to the TreeViewPane constructor.  For example, the color of the text
 * in the tree would be specified by the property
 * <TT><I>&lt;prefix&gt;</I>.textColor</TT>
 * where "<I>&lt;prefix&gt;</I>" is the value of the <I>prefix</I> argument
 * passed to the TreeViewPane constructor.</P>
 * <P>The structure of the tree is defined by properties in the
 * ResourceStack:</P>
 * <P><TT><I>&lt;prefix&gt;</I>.tree<I>&lt;n&gt;</I></TT> specifies an array
 * of tree names,
 * one for each tree structure.  For each <I>treename</I> so specified,
 * <TT><I>&lt;prefix&gt;</I>.<I>&lt;treename&gt;</I>.level<I>&lt;n&gt;</I></TT>
 * specifies an array of Category corresponding to each level in the tree.</P>
 * <P>The Category at level 0 of each tree must match the type of the root
 * Item of the TreeViewPane.
 * Each level of the tree is populated by the members of an Association
 * between the Item we're displaying and the Category at the next level.
 * For each Item in level <I>&lt;n&gt;</I>, we monitor the Association with
 * the Category at level <I>&lt;n+1&gt;</I>.</P>
 * <P>If it is necessary to use a Category instead of an Association at a
 * given level in the tree, specify it by setting the property <PRE>
 *   <I>&lt;prefix&gt;</I>.<I>&lt;treename&gt;</I>.level<I>&lt;n&gt;</I>.useAssoc = false
 </PRE></P>
 * <P>The default values for the properties contained here are defined in
 * com.sgi.sysadm.ui.treeView.TreeViewP.properties and may be
 * overridden by properties file(s) of the product.</P>
 *
 * @author	John Relph
 * @version	$Revision: 1.9 $ $Date: 2000/07/24 21:58:15 $
 *
 * @see		com.sgi.sysadm.ui.treeView.TreeViewPane
 */
public interface TreeViewProperties {

    /**
     * The property <TT><I>&lt;prefix&gt;.textColor</I></TT> specifies the
     * color to be used to display the name of the Item at each node of the
     * tree.
     */
    static public final String TEXT_COLOR = ".textColor";

    /**
     * The property <TT><I>&lt;prefix&gt;.selectColor</I></TT> specifies the
     * color to be used as the background of the selected Item in the tree.
     */
    static public final String SELECT_COLOR = ".selectColor";

    /**
     * The property <TT><I>&lt;prefix&gt;.rootFont</I></TT> specifies the
     * name of the font to be used to display the name of the Item at the
     * root node of the tree.
     */
    static public final String ROOT_FONT = ".rootFont";

    /**
     * The property <TT><I>&lt;prefix&gt;.childFont</I></TT> specifies the
     * name of the font to be used to display the name of all Items in the
     * tree (except for the Item at the root of the tree).
     */
    static public final String CHILD_FONT = ".childFont";

    /**
     * The property <TT><I>&lt;prefix&gt;.cellBorderHeight</I></TT>
     * specifies the height, in points, of the border around each Item in
     * the tree.
     */
    static public final String CELL_BORDER_HEIGHT = ".cellBorderHeight";

    /**
     * The property <TT><I>&lt;prefix&gt;.cellBorderWidth</I></TT> specifies
     * the width, in points, of the border around each Item in the tree.
     */
    static public final String CELL_BORDER_WIDTH = ".cellBorderWidth";

    /**
     * The property <TT><I>&lt;prefix&gt;.iconWidth</I></TT> specifies the
     * width, in points, of the icon to be displayed at each node of the
     * tree.
     */
    static public final String ICON_WIDTH = ".iconWidth";

    /**
     * The property <TT><I>&lt;prefix&gt;.iconHeight</I></TT> specifies the
     * height, in points, of the icon to be displayed at each node of the
     * tree.
     */
    static public final String ICON_HEIGHT = ".iconHeight";

    /**
     * The property <TT><I>&lt;prefix&gt;.tree&lt;n&gt;</I></TT> is a string
     * array that specifies the names of the trees to be displayed in the
     * TreeViewPane.  One tree can be displayed at a time.
     */
    static public final String TREE = ".tree";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;treename&gt;.showRoot</I></TT> is a boolean
     * which specifies whether the root node in the tree is to be displayed
     * when this tree is displayed.
     */
     static public final String SHOW_ROOT = ".showRoot";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;treename&gt;.level&lt;n&gt;</I></TT> is a
     * string array which specifies the package-qualified names of the
     * Categories of Items to be displayed at each level of the tree.
     * <I>&lt;treename&gt;</I> must have been specified using the <A
     * HREF="#TREE">TREE</A> property.  These Category names are used to
     * find the <A HREF="#BLINK">BLINK</A>, <A
     * HREF="#STATE_ATTR">STATE_ATTR</A>, <A
     * HREF="#ITEM_COMPARATOR">ITEM_COMPARATOR</A>, <A
     * HREF="#DISPLAY_ATTR">DISPLAY_ATTR</A>, and <A
     * HREF="#DISPLAY_ATTR_ARG">DISPLAY_ATTR_ARG</A> properties.
     */
    static public final String LEVEL = ".level";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;treename&gt;.level&lt;n&gt;.useAssoc</I></TT>
     * specifies whether to use an Association or a Category at this level
     * of the tree.  If it is necessary to use a Category instead of an
     * Association at a given level in the tree, specify it by setting the
     * following property:<PRE>
     *   <I>&lt;prefix&gt;</I>.<I>&lt;treename&gt;</I>.level<I>&lt;n&gt;</I>.useAssoc = false
     * </PRE>
     */
    static public final String USE_ASSOC = ".useAssoc";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;treename&gt;.level&lt;n&gt;.rootFilterAttr</I></TT>
     * is only used if <A HREF="#USE_ASSOC">USE_ASSOC</A> is false.  If so,
     * ROOT_FILTER_ATTR specifies the name of an Attribute of the
     * <I>rootItem</I>.  If the value of that Attribute of the root Item of
     * the tree matches the value of that Attribute in each Item in the
     * Category, then the Item is added to the tree.
     */
    static public final String ROOT_FILTER_ATTR = ".rootFilterAttr";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;treename&gt;.itemTester</I></TT>
     * specifies the package-qualified name of a class which implements the
     * ItemComparator interface for a given category.  The class is used to
     * compare two Items in a Category in order to sort the Items in the
     * tree.
     *
     * @see com.sgi.sysadm.category.ItemTester
     */
    static public final String ITEM_TESTER = ".itemTester";

    /**
     * The property <TT><I>&lt;prefix&gt;.toolTipText</I></TT> specifies the
     * string to be displayed as the ToolTip text for each node in the tree.
     */
    static public final String TOOLTIP_TEXT = ".toolTipText";

    /**
     * The property <TT><I>&lt;prefix&gt;.background</I></TT> specifies the
     * color to be used as the background for the TreeViewPane.
     */
    static public final String BACKGROUND = ".background";

    /**
     * The property <TT><I>&lt;prefix&gt;.openedIcon</I></TT> specifies the
     * package-qualified name of the icon to display when a node in the tree
     * has children and those children are visible, that is, when the node
     * is open.
     */
    static public final String OPENED_ICON = ".openedIcon";

    /**
     * The property <TT><I>&lt;prefix&gt;.closedIcon</I></TT> specifies the
     * package-qualified name of the icon to display when a node in the tree
     * has children and those children are not visible, that is, when the
     * node is closed.
     */
    static public final String CLOSED_ICON = ".closedIcon";

    /**
     * The property <TT><I>&lt;prefix&gt;.width</I></TT> specifies the
     * default width, in points, of the tree pane.
     */
    static public final String PANE_WIDTH = ".width";

    /**
     * The property <TT><I>&lt;prefix&gt;.height</I></TT> specifies the
     * default height, in points, of the tree pane.
     */
    static public final String PANE_HEIGHT = ".height";

    /**
     * The property
     * <TT><I>&lt;prefix&gt;.&lt;categoryname&gt;.itemComparator</I></TT>
     * specifies the package-qualified name of a class which implements the
     * ItemComparator interface for a given category.  The class is used to
     * compare two Items in a Category in order to sort the Items in the
     * tree.
     *
     * @see com.sgi.sysadm.category.ItemComparator
     */
    static public final String ITEM_COMPARATOR = ".itemComparator";

    /**
     * The String <I>TreeViewPane</I> is used as the prefix for a number of
     * properties and has been made available to other classes as a
     * convenience.
     */
    static final String TREEVIEWPANE_PROPERTY_PREFIX =
	"TreeViewPane";
}
