//
// ResultEvent.java
//
//	Event for returning a result.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.util;

import java.util.EventObject;

/**
 * ResultEvent represents the result of some operation.  The success
 * or failure of an operation is represented by which method on
 * ResultListener is being called.
 */
public class ResultEvent extends EventObject {
    private String _reason = null;
    private Object _result = null;

    /**
     * ResultEvent constructor.
     * 
     * @param source source of this event.
     */
    public ResultEvent(Object source) {
	super(source);
    }

    /**
     * Construct a ResultEvent.  This constructor specifies an Object
     * that is the result.
     * 
     * @param source source of this event.
     * @param result event of the operation that completed.
     */
    public ResultEvent(Object source, Object result) {
	super(source);
	_result = result;
    }

    /**
     * Set the reason that this operation failed.
     * 
     * @param reason The reason this operation failed.
     */
    public void setReason(String reason) {
	_reason = reason;
    }

    /**
     * Get the reason this operation failed.
     * 
     * @return The reason this operation failed.
     */
    public String getReason() {
	return _reason;
    }

    /**
     * Set the Object representing the result of this operation.
     *
     * @param result An Object representing the result of this operation.
     */
    public void setResult(Object result) {
	_result = result;
    }

    /**
     * Get an Object representing the result of an operation.
     * 
     * @return The result of this operation.
     */
    public Object getResult() {
	return _result;
    }
}
