//
// ResultListener.java
//
//	Interface for receiving results of an operation.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

package com.sgi.sysadm.util;

import java.util.EventListener;

/**
 * ResultListener methods are called when an operation succeeds or
 * fails.  The purpose of ResultListener is to provide a generic way
 * for classes to define asynchronous methods.  One of the
 * parameters to such an asynchronous method is a
 * ResultListener, which gets notified of the success or
 * failure of the method.
 * <pp>
 * For example, the following code calls
 * <tt>java.com.sgi.sysadm.ui.Task.runPriv</tt>, and causes the task to succeed
 * or fail based on asynchronous notification about whether or not the
 * <tt>runPriv</tt> operation succeeded.
 * <pre>
 * 	stream = runPriv(privcmdName, taskData, new ResultListener() {
 * 	    public void succeeded(ResultEvent event) {
 * 		_taskContext.notBusy();
 * 		taskSucceeded(event);
 * 	    }
 * 
 * 	    public void failed(ResultEvent event) {
 * 		_taskContext.notBusy();
 * 		taskFailed(event);
 * 	    }
 * 	});
 * </pre>	
 */
public interface ResultListener extends EventListener {

    /**
     * Called when an asynchronous operation succeeds.
     * The result of the operation is typically accessible via
     * <tt>event.getResult</tt>.
     * 
     * @param event ResultEvent optionally containing result Object.
     */
    public abstract void succeeded(ResultEvent event);

    /**
     * Called when an asynchronous operation fails.
     * The reason for the failure is typically accessible via
     * <tt>event.getReason</tt>.
     * 
     * @param event ResultEvent optionally containing reason for
     *              failure.
     */
    public abstract void failed(ResultEvent event);
}
