//
// AssociationListenerProxy.c++
//
//	Proxy Class for monitoring changes in a Association.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.8 $"

#include "AssociationListenerProxy.h"

BEGIN_NAMESPACE(sysadm);

#define ITEM "item"
#define ITEMADDED "itemAdded"
#define ITEMCHANGED "itemChanged"
#define NEWITEM "newItem"
#define ITEMREMOVED "itemRemoved"
#define SELECTOR "selector"
#define BEGINBLOCKCHANGES "beginBlockChanges"
#define ENDBLOCKCHANGES "endBlockChanges"
#define ENDEXISTS "endExists"
#define ERROR "error"
#define ERRORSTRING "errorString"

//
//  AssociationListenerProxy Implementation
//
class AssociationListenerProxyImpl {
  public:
    AssociationListenerProxyImpl(Connection& conn,
			      const String& serviceName)
    : _conn(conn), _serviceName(serviceName) { }
    Connection& _conn;
    String _serviceName;
};

//
// Constructor
//
AssociationListenerProxy::AssociationListenerProxy(Connection& conn,
					     const String& serviceName) :
    _impl(new AssociationListenerProxyImpl(conn, serviceName)) {
}

//
// Destructor 
//
AssociationListenerProxy::~AssociationListenerProxy() {
    delete _impl;
}

// 
// AssociationListenerProxy overrides the base class methods to send the 
// notification to the AssociationProxy named by serviceName
//
//
void AssociationListenerProxy::itemAdded(const Item& item) {
    Packet packet(_impl->_serviceName, ITEMADDED);
    packet.setAttr(Attribute(ITEM, item));

    // Send it over the wire
    _impl->_conn.sendPacket(packet);
}

void AssociationListenerProxy::itemChanged(const Item&, 
					const Item& newItem) {
    Packet packet(_impl->_serviceName, ITEMCHANGED);
    packet.setAttr(Attribute(NEWITEM, newItem));

    // Send it over the wire
    _impl->_conn.sendPacket(packet);
}

void AssociationListenerProxy::itemRemoved(const Item& item) {
    Packet packet(_impl->_serviceName, ITEMREMOVED);
    packet.setAttr(Attribute(SELECTOR, item.getSelector()));
    
    // Send it over the wire
    _impl->_conn.sendPacket(packet);
}

void AssociationListenerProxy::beginBlockChanges() {
    _impl->_conn.sendPacket(Packet(_impl->_serviceName, BEGINBLOCKCHANGES));
}

void AssociationListenerProxy::endBlockChanges() {
    _impl->_conn.sendPacket(Packet(_impl->_serviceName, ENDBLOCKCHANGES));
}

void AssociationListenerProxy::endExists() {
    _impl->_conn.sendPacket(Packet(_impl->_serviceName, ENDEXISTS));
}

void AssociationListenerProxy::attrChanged(const AttrEvent& /*event*/) {
}

void AssociationListenerProxy::categoryError(CategoryErrorEvent& event) {
     Packet packet(_impl->_serviceName, ERROR);

     packet.setAttr(Attribute(ERRORSTRING, event.getErrorString()));

     // Send it over the wire
    _impl->_conn.sendPacket(packet);
}

END_NAMESPACE(sysadm);
