//
// AssociationListenerProxy.h
//
//	Proxy class for monitoring changes in a Association.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.6 $"
#ifndef _SYSADM_ASSOCIATION_LISTENER_PROXY_H
#define _SYSADM_ASSOCIATION_LISTENER_PROXY_H

#include <sysadm/CategoryListener.h>
#include <sysadm/CategoryErrorListener.h>
#include <sysadm/Connection.h>

BEGIN_NAMESPACE(sysadm);

// 
// AssociationListenerProxy overrides the base class methods to send the 
// notification to the AssociationProxy named by "serviceName" 
// in the constructor argument

class AssociationListenerProxy : public CategoryListener, 
				 public CategoryErrorListener {
    
  public:

    // Constructor
    AssociationListenerProxy(Connection& conn, const String& serviceName);

    // Destructor
    virtual ~AssociationListenerProxy();

    // Called by Association after an Item has been added or 
    // detected at startup.
    virtual void itemAdded(const Item& item);

    // Called by Association when an Item changes.  
    virtual void itemChanged(const Item& oldItem, const Item& newItem);

    // Called by Association when an Item is removed.
    virtual void itemRemoved(const Item& item);

    // Called by Association prior to a block of changes.  For example,
    // Assciation::replaceItemList() calls
    // beginBlockChanges() before changing the list.
    virtual void beginBlockChanges();

    // Called by Association after a block of changes.
    virtual void endBlockChanges();

    // Called by Association after notification of current state.
    virtual void endExists();

    // Not called by Association.
    virtual void attrChanged(const AttrEvent& event);

    // Called by Category when an error occurs
    virtual void categoryError(CategoryErrorEvent& event);

  private:

    // Intentionally undefined.
    AssociationListenerProxy(const AssociationListenerProxy&);
    AssociationListenerProxy& operator=(const AssociationListenerProxy&);
    
    // Opaque implementation.
    friend class AssociationListenerProxyImpl;
    AssociationListenerProxyImpl* _impl;
};

END_NAMESPACE(sysadm);

#endif  //  _SYSADM_ASSOCIATION_LISTENER_PROXY_H
