//
// AssociationPacketListener.c++
//
//	Respond to client requests for a particular association.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.6 $"
#include <sysadm/Log.h>
#include "AssociationPacketListener.h"

// Constructor.
AssociationPacketListener::AssociationPacketListener(Connection& conn,
						     const String& serviceName,
						     Association& association)
: _conn(conn), _serviceName(serviceName), _association(association),
_listenerHandle(NULL), _errorListenerHandle(NULL) {
}

// Destructor.
AssociationPacketListener::~AssociationPacketListener() {
    Log::debug("AssociationPacketListener",
	       "~AssociationPacketListener");
    // Only one remove is required since AssociationListenerProxy
    // implements the AssociationListener and AssociationErrorListener
    // interface.
    if (_errorListenerHandle != NULL) {
	_association.orphanErrorListener(_errorListenerHandle);
    }
    if (_listenerHandle != NULL) {
	_association.removeCategoryListener(_listenerHandle);
    }
}

//
//  void AssociationPacketListener::receivePacket(const Packet& packet)
//
//  Description:
//      Respond to message from client.
//
//  Parameters:
//      packet Packet received.
//
void AssociationPacketListener::receivePacket(const Packet& packet) {
    if (packet.getSelector() == "addAssociationListener") {
	NotificationFilter filter;
	filter.monitorAllItems();
	AssociationListenerProxy* listener = 
	    new AssociationListenerProxy(_conn, _serviceName);
	_errorListenerHandle = _association.adoptErrorListener(listener);
	_listenerHandle = _association.adoptCategoryListener(listener,
							     filter);
    } else {
	Log::debug("AssociationPacketListener", 
		   "Got unrecognized packet with selector %s", 
		   (const char*) packet.getSelector());
    }
}

//
//  Association* AssociationPacketListener::getAssociation()
//
//  Description:
//      Get the Association related to this AssociationPacketListener.
//
//  Returns:
//	Association
//
Association* AssociationPacketListener::getAssociation()
 {
    return &_association;
}
