//
// UnixServerAuth.h
//
//	Server side of unix authentication.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include <sysadm/Authenticator.h>

USING_NAMESPACE(sysadm);

//
// UnixServerAuth implements the server side of unix authentication,
// which involves verifying that a login name and password are valid
// according to the passwd database.
//
class UnixServerAuth : public Authenticator, private PacketListener {
  public:

    // Constructor.
    UnixServerAuth();

    // Destructor.
    virtual ~UnixServerAuth();

    // Called to start the authentication process.
    virtual void authenticate(ResultListener* adoptedListener);

    // Called when a packet arrives for us.
    virtual void receivePacket(const Packet& packet);

  private:

    bool passwordRequired();
    bool dceVerify(struct passwd* pw, const char* password);
#ifdef HAVE_IA_H
    bool isInactive(const struct passwd* pw, const uinfo_t uninfo);
    bool isAged(const uinfo_t uninfo);
#endif  //  HAVE_IA_H
    bool checkPassword(struct passwd* pw, const char* password);

    ResultListener* _listener;
    int _attempts;
    time_t _dayNow;
};
