//
// CategoryListenerProxy.h
//
//	Proxy class for monitoring changes in a Category.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.12 $"
#ifndef _SYSADM_CATEGORY_LISTENER_PROXY_H
#define _SYSADM_CATEGORY_LISTENER_PROXY_H

#include <sysadm/CategoryListener.h>
#include <sysadm/CategoryErrorListener.h>
#include <sysadm/Connection.h>

BEGIN_NAMESPACE(sysadm);

// 
// CategoryListenerProxy overrides the base class methods to send the 
// notification to the CategoryProxy named by "serviceName" in the constructor
// argument

class CategoryListenerProxy : public CategoryListener, 
			      public CategoryErrorListener {
    
  public:

    // Constructor
    CategoryListenerProxy(Connection& conn, const String& serviceName);

    // Destructor
    virtual ~CategoryListenerProxy();

    // Called by Category after an Item has been added or 
    // detected at startup.
    virtual void itemAdded(const Item& item);

    // Called by Category when an Item changes.  
    virtual void itemChanged(const Item& oldItem, const Item& newItem);

    // Called by Category when an Item is removed.
    virtual void itemRemoved(const Item& item);

    // Called by Category prior to a block of changes.  For example,
    // Category::replaceItemList() calls
    // beginBlockChanges() before changing the list.
    virtual void beginBlockChanges();

    // Called by Category after a block of changes.
    virtual void endBlockChanges();

    // Called by Category after notification of current state.
    virtual void endExists();

    // Called by Category after a Category attribute
    // has been added or detected at startup
    virtual void attrChanged(const AttrEvent& event);

    // Called by Category when an error occurs
    virtual void categoryError(CategoryErrorEvent& event);

  private:

    // Intentionally undefined.
    CategoryListenerProxy(const CategoryListenerProxy&);
    CategoryListenerProxy& operator=(const CategoryListenerProxy&);
    
    // Opaque implementation.
    friend class CategoryListenerProxyImpl;
    CategoryListenerProxyImpl* _impl;
};

END_NAMESPACE(sysadm);

#endif  //  _SYSADM_CATEGORY_LISTENER_PROXY_H
