//
// CategoryPacketListener.c++
//
//	Respond to client requests for a particular category.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.10 $"
#include <sysadm/Log.h>
#include "CategoryPacketListener.h"

CategoryPacketListener::CategoryPacketListener(Connection& conn,
					       const String& serviceName,
					       Category& category)
: _conn(conn), _serviceName(serviceName), _category(category),
_listenerHandle(NULL), _errorListenerHandle(NULL) {
}

CategoryPacketListener::~CategoryPacketListener() {
    Log::debug("CategoryPacketListener", "~CategoryPacketListener");
    // Only one remove is required since CategoryListenerProxy
    // implements the CategoryListener and CategoryErrorListener
    // interface.
    if (_errorListenerHandle != NULL) {
	_category.orphanErrorListener(_errorListenerHandle);
    }
    if (_listenerHandle != NULL) {
	_category.removeCategoryListener(_listenerHandle);
    }
}

void CategoryPacketListener::receivePacket(const Packet& packet) {
    if (packet.getSelector() == "adoptNotificationFilter") {
	CategoryListenerProxy* listener = 
	    new CategoryListenerProxy(_conn, _serviceName);

	NotificationFilter filter;
	filter.monitorAllItems();
	filter.monitorCategoryAttrs();
	_errorListenerHandle = _category.adoptErrorListener(listener);
	_listenerHandle = _category.adoptCategoryListener(listener, filter);
    } else {
	Log::debug("CategoryPacketListener", 
		   "Got unrecognized packet with selector %s", 
		   (const char*) packet.getSelector());
    }
}

Category* CategoryPacketListener::getCategory() {
    return &_category;
}
