//
// PrivListener.h
//
//	Privilege Service Listener.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.6 $"

#include <sysadm/PacketListener.h>
#include <sysadm/Connection.h>

USING_NAMESPACE(sysadm);

class Job;

//
// PrivListener implements the "privilege" service, checking, adding
// and running privileges.
//
class PrivListener : public PacketListener {
  public:

    // Constructor.
    PrivListener(Connection& conn, const String& serviceName);

    // Destructor.
    virtual ~PrivListener();

    // Called by Connection when a packet arrives for us.
    virtual void receivePacket(const Packet& packet);

  private:

    // Intentionally undefined.
    PrivListener(const PrivListener&);
    PrivListener& operator=(const PrivListener&);

    void run(const Packet& packet);
    void input(const Packet& packet);
    void destroy(const Packet& packet);
    void check(const Packet& packet);
    void add(const Packet& packet);
    void checkPassword(const Packet& packet);
    
    Job* getJob(long long jobId);

    static void handleCommandOutput(void* clientData, int id, int fd);
    int runAdminCommand(Command& command, const Packet& packet);
    void sendPassword(Command& command, const String& password);
    static void jobFinished(Job* job, int exitCode);

    Connection& _conn;
    String _serviceName;
    CollectionOf<Job> _jobs;
};
