//
// ProductInfo.c++
//
//	Obtains the infomation stored in the 
//      /var/sysadm/products/<product>/productAttrs directory
//
//  Copyright (c) 1999, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include "ProductAttrs.h"
#include <sysadm/Log.h>
#include <sysadm/String.h>
#include <sysadm/format.h>
#include <limits.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sysadm/OrderedFileName.h>

#define CLASS_NAME "ProductAttrs"

USING_NAMESPACE(sysadm);

String * ProductAttrs::getProductAttrs(const String& product) {

    char dirName[PATH_MAX];
    SaStringFormat(dirName, sizeof dirName, 
		   "%s/%s/productAttrs",
		   CONFIG_SYSADM_PRODUCTS_DIR, (const char*) product);
    
    OrderedFileName** files =
	OrderedFileName::createOrderedFileNamesFromDir(dirName);
        
    if (files == NULL) {
	return NULL;
    }
    String * attrs = new String("");
    for (int ii = 0; files[ii] != NULL; ii++) {
	String fileAsString =
	    StringFromFile(files[ii]->getFullPath());
	if (fileAsString != String::NUL) {
	    *attrs += fileAsString;
	} else {
	    Log::debug(CLASS_NAME, "Error reading file %s."
		       "The error was: %s", files[ii]->getFullPath(),
		       strerror(errno));
	}
    }
    OrderedFileName::destroyOrderedFileNameList(files);
    Log::debug(CLASS_NAME, "The attributes are: %s" , (const char*) *attrs);
    return attrs;
}










