//
// info.c++
//
//	A service for obtaining the infomation stored in the
//	/var/sysadm/products directory on the server
//
//
//  Copyright (c) 1999, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.3 $"

#include <values.h>
#include <string.h>
#include <sysadm/PacketListener.h>
#include <sysadm/Connection.h>
#include <sysadm/Log.h>
#include "ProductAttrs.h"

#define GET_PRODUCT_ATTRIBUTES "getProductAttrs"
#define COOKIE "cookie"
#define RESULT "result"
#define REASON "reason"
#define PRODUCT "product"
#define ATTRS "attrs"
#define NO_ATTRS_DIR "NoAttributesDirectory"

using namespace sysadm;

class ProductInfoListener : public PacketListener {
  public:
    ProductInfoListener(Connection& conn);
    ~ProductInfoListener();
    void getProductAttrs(const Packet& packet);

    virtual void receivePacket(const Packet& packet);
    Connection& _conn;
};

//
// Constructor
//
ProductInfoListener::ProductInfoListener(Connection& conn) :
    _conn(conn) {
}

// 
// Destructor
//
ProductInfoListener::~ProductInfoListener() {
}

void ProductInfoListener::receivePacket(const Packet& packet) {

    if (packet.getSelector() == GET_PRODUCT_ATTRIBUTES) {
	getProductAttrs(packet);
    } else {
	 Log::debug("ProductInfoListener", 
		    "Got unrecognized packet with selector %s", 
		    (const char*) packet.getSelector());
    }
}

void ProductInfoListener::getProductAttrs(const Packet& packet) {

    // Get ProductInfo for a particular product
    String product = packet.getAttr(PRODUCT).stringValue();
    Packet reply(packet.getType(), RESULT);
    reply.setAttr(packet.getAttr(PRODUCT));
    reply.setAttr(packet.getAttr(COOKIE));
    
    String * attrs =  ProductAttrs::getProductAttrs(product);
    if (attrs == NULL) {
        reply.setAttr(Attribute(RESULT, false));
	reply.setAttr(Attribute(REASON, NO_ATTRS_DIR));
    } else {
        reply.setAttr(Attribute(RESULT, true));
	reply.setAttr(Attribute(ATTRS,*attrs));
	delete attrs;
    }
    _conn.sendPacket(reply);
}

//
// Called by sysadmd to dynamically load the taskRegistry service.
//
extern "C" void* CreatePacketListener(Connection& conn, const String&)
{
    return new ProductInfoListener(conn);
}
