//
// TaskRegistry.c++
//
//	Determines tasks pertaining to CategoryView and ItemView
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.7 $"

#include "TaskRegistry.h"
#include <sys/types.h>
#include <ctype.h>
#include <dirent.h>
#include <limits.h>
#include <stdio.h>
#include <strings.h>
#include <sysadm/Log.h>
#include <sysadm/format.h>
#include <sysadm/OrderedFileName.h>

#define TASK_REGISTRY "taskRegistry"

StringList* TaskRegistry::createTaskList(const String& catName) {
    StringList * taskList = new StringList();
    char dirName[PATH_MAX];

    SaStringFormat(dirName, sizeof dirName, "%s/%s",
		   CONFIG_SYSADM_TASKREGISTRY_DIR, (const char*) catName);
    Log::debug(TASK_REGISTRY, dirName);

    OrderedFileName** files =
	OrderedFileName::createOrderedFileNamesFromDir(dirName);
        
    if (files == NULL) {
	return taskList;
    }
    for (int ii = 0; files[ii] != NULL; ii++) {
	taskList->append(new
			 String(files[ii]->getName()));
    }
     OrderedFileName::destroyOrderedFileNameList(files);
     return taskList;
}


