//
// registry.c++
//
//	Task Registry service.
//
//
//  Copyright (c) 1998, 2000 Silicon Graphics, Inc.  All Rights Reserved.
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of version 2.1 of the GNU Lesser General Public
//  License as published by the Free Software Foundation.
//  
//  This program is distributed in the hope that it would be useful, but
//  WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  
//  Further, this software is distributed without any warranty that it is
//  free of the rightful claim of any third person regarding infringement
//  or the like.  Any license provided herein, whether implied or
//  otherwise, applies only to this software file.  Patent licenses, if
//  any, provided herein do not apply to combinations of this program
//  with other software, or any other product whatsoever.
//  
//  You should have received a copy of the GNU Lesser General Public
//  License along with this program; if not, write the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston MA 02111-1307,
//  USA.
//  
//  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
//  Mountain View, CA 94043, or http://www.sgi.com/
//  
//  For further information regarding this notice, see:
//  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
//

#ident "$Revision: 1.4 $"

#include <values.h>
#include <string.h>
#include <sysadm/PacketListener.h>
#include <sysadm/Connection.h>
#include <sysadm/Log.h>
#include "TaskRegistry.h"

#define GETTASKLIST "getTaskList"
#define COOKIE "cookie"
#define CATEGORY "category"
#define NUMTASKS "numTasks"
#define PARAM "param"
#define RESULT "result"

class TaskRegistryListener : public PacketListener {
  public:
    TaskRegistryListener(Connection& conn);
    ~TaskRegistryListener();
    void getTaskList(const Packet& packet);

    virtual void receivePacket(const Packet& packet);
    Connection& _conn;
    TaskRegistry* _taskRegistry;
    
};

//
// Constructor
//
TaskRegistryListener::TaskRegistryListener(Connection& conn) :
    _conn(conn), _taskRegistry(new TaskRegistry()) {
}

// 
// Destructor
//
TaskRegistryListener::~TaskRegistryListener() {
    delete _taskRegistry;
}

void TaskRegistryListener::receivePacket(const Packet& packet) {

    if (packet.getSelector() == GETTASKLIST) {
	getTaskList(packet);
    } else {
	 Log::debug("TaskRegistryListener", 
		    "Got unrecognized packet with selector %s", 
		    (const char*) packet.getSelector());
    }
}

void TaskRegistryListener::getTaskList(const Packet& packet) {

    // Get Task List for catName
    String catName = packet.getAttr(CATEGORY).stringValue();
    StringList* taskList = _taskRegistry->createTaskList(catName);

    Packet reply(packet.getType(), RESULT);
    reply.setAttr(packet.getAttr(CATEGORY));
    reply.setAttr(packet.getAttr(COOKIE));

    // Calculate the number of characters that correspond to the size
    // of the array
    int taskListSize = taskList->getSize();
    Log::debug("TaskRegistryListener", "taskList size = %d", taskListSize);
    reply.setAttr(Attribute(NUMTASKS, (long long) taskListSize));
 
    short count = 0;
    while (taskListSize) {
	taskListSize /= 10;
	count++;
    }
    count += strlen(PARAM);
    char buf[count+1];

    IteratorOver<String> iter(taskList);
    String* str;
    int ii = 0;
    while ((str = iter()) != NULL) {
	Log::debug("TaskRegistryListener", "%s", (const char*) *str);
	sprintf(buf, "%s%d", PARAM, ii++);
	reply.setAttr(Attribute(buf, *str));
    }
	
    _conn.sendPacket(reply);
    RemoveAndDestroyContentsOf(taskList);
    delete taskList;
}

//
// Called by sysadmd to dynamically load the taskRegistry service.
//
extern "C" void* CreatePacketListener(Connection& conn, const String&)
{
    return new TaskRegistryListener(conn);
}

