#!/usr/bin/perl
#
# This program reads an SGI Desktop .ftr file and creates a separate
# .java file for each TYPE defined that contains an ICON part.  The
# .java file defines a class that can draw the icon.  The parts of
# each TYPE other than ICON are ignored.

require "getopts.pl";
&Getopts('p:i:b:');    

if ($#ARGV != 0) {
    die "Usage: ftrjava [ -p package ] [ -i imports ] [ -b interface ] <ftr-file>\n";
}

$package = "";
if ($opt_p) {
    $package = $opt_p;
}
$imports = "";
if ($opt_i) {
    $imports = $opt_i;
}
$interface = "";
if ($opt_b) {
    $interface = $opt_b;
}

open(FTR, $ARGV[0]) || die "$ARGV[0]: $!\n";

$tempFile = $ARGV[0].tmp;
open(TEMP, ">$tempFile") || die "$tempFile: $!\n";

#
# Copy input to a temp file, expanding one level of include
# directives.  Multiple levels of include are not supported.
#
while ($line = <FTR>) {
    if ($line =~ /^\s*include\(\"([^\"]*)\"\)/) {
	$inc = $1;
	open(INCLUDE, $1) || die "$1: $!\n";
	while ($line = <INCLUDE>) {
	    print(TEMP $line);
	}
	close(INCLUDE);
	#
	# Keep track of include files that we've expanded, so that
	# we can keep Makedepend up to date.
	#
	$incs = $dep{"$currentType.java"};
	$incs .= " $inc";
	$dep{"$currentType.java"} = $incs;
    } else {
	if ($line =~ /^\s*TYPE\s+([^\s]+)/) {
	    $currentType = $1;
	}
	print(TEMP $line);
    }
}

close(FTR);
close(TEMP);

open(TEMP, $tempFile) || die "$tempFile: $!\n";

#
# Write a header, the ICON part of the rule, and a footer to the .java
# file.  The ICON syntax is all legal java syntax, except for the
# comments which we translate.
#
while ($line = <TEMP>) {
    if ($line =~ /^\s*TYPE\s+([^\s]+)/) {
	$currentType = $1;
    } elsif ($line =~ /\s*ICON/) {
	open(ICON, ">$currentType.java") || die "$currentType.java: $!\n";
	print(ICON "// This file was automatically generated by ftrjava.\n");
	if ($package) {
	    print(ICON "package $package;\n");
	}
	print(ICON "import com.sgi.sysadm.ui.*;\n");
	if ($imports) {
	    print(ICON "import $imports;\n");
	}
	print(ICON "public class $currentType extends FtrIcon ");
	if ($interface) {
	    print(ICON "implements $interface ");
	}
	print(ICON "{\n");
	print(ICON "    protected void draw() {\n");
	while ($line = <TEMP>) {
	    if ($line =~ /^\s*TYPE\s+([^\s]+)/) {
		$currentType = $1;
		goto done;
	    } elsif ($line =~ /^\s*\#(.*)$/) {
		print(ICON "//$1\n");
	    } else {
		print(ICON $line);
	    }
	}
done:
	print(ICON "}\n");
	close(ICON);
    }
}

unlink($tempFile);

#
# Update Makedepend so that the .java files depend on the .fti files
# included by the ftr files.
#
if (!open(TEMP, ">$tempFile")) {
    print "Warning: unable to update Makedepend: $!\n";
    exit 0;
}

if (open(MKDEP, "Makedepend")) {
    while ($line = <MKDEP>) {
	if ($line =~ /([^:]+):/ && ($incs = $dep{$1})) {
	    $dep{$1} = "";
	    print(TEMP "$1:$incs\n");
	} else {
	    print(TEMP $line);
	}
    }
    close(MKDEP);
}
	
@dep = %dep;

for ($ii = 0; $ii < $#dep; $ii += 2) {
    $javaFile = $dep[$ii];
    if ($incs = $dep{$javaFile}) {
	print(TEMP "$javaFile: $incs\n");
    }
}

close(TEMP);

rename($tempFile, "Makedepend")
    || print "Warning: unable to update Makedepend: $!\n";
