#!/usr/bin/perl
#
# This program makes a copy of the tree rooted at com under jarlinks,
# including only files that should go into a jar file.  This is to work
# around the problem that the jar program only accepts arguments
# on the command line which is not in general big enough.
#
# If the -m flag is specified, then this program displays the names of the
# files that would go in the jar file (but does not copy the tree).
#
# THIS FILE IS (slightly) BROKEN (for some people under some circumstances);
# see bug 795103.

use Getopt::Long;
&GetOptions("s=s", "d=s", "e=s", "m", "l=s", "v", "x=s\@");

if (!$opt_s || !($opt_d || $opt_m) || $#ARGV == -1) {
    die("usage: jarlinks [-m] [-l lang] [-v] [-x exclude-expr [-x ...]] -s source -d dest -e exclude-file expr [ expr... ]\n");
}

if ($opt_m && $opt_d) {
    warn "jarlinks: -d $opt_d ignored with -m\n";
}

if ($opt_m && $opt_l) {
    warn "jarlinks: -l $opt_l ignored with -m\n";
}

$numExcludes = 0;
if ($opt_e) {
    open(EXFILE, $opt_e) || die("$opt_e: $!\n");
    while ($line = <EXFILE>) {
	chop($line);
	$opt_v && print "excluding pattern \"$line\"\n";
	$excludes[$numExcludes++] = $line;
    }
}

foreach (@opt_x) {
    $opt_v && print "excluding pattern \"$_\"\n";
    $excludes[$numExcludes++] = $_;
}

$expr = "";
for ($i = 0; $i <= $#ARGV; $i++) {
    if ($i > 0) {
	$expr = $expr . " -o ";
    }
    $expr = $expr . " -name $ARGV[$i] ";
}

open(PWD, "pwd|") || die "pwd: $!\n";
$cwd=<PWD> || die "pwd: $!\n";
close(PWD);
chop $cwd;

$cmd = "sh -c \"set -f; find $opt_s $expr\"";
$opt_v && print "executing \"$cmd\"\n";
open(FIND, "$cmd|") || die "find: $!\n";

$base = $opt_d;

while ($file = <FIND>) {
    $skip = 0;
    chop $file;
    for ($ii = 0; !$skip && $ii < $numExcludes; $ii++) {
	if ($file =~ /$excludes[$ii]/) {
	    #  Avoid the case where, say, our lang is en_CA.mountie,
	    #  and langs which we're excluding are en and en_CA.  We
	    #  don't actually want to skip files containing en_CA.mountie,
	    #  even if they match our en or en_CA exclusion pattern!
	    $opt_l && ($opt_l =~ /$excludes[$ii]/) && ($file =~ /$opt_l/) && next;
	    $opt_v && print "skipping $file\n";
	    $skip = 1;
	}
    }
    if (!$skip) {
	if ($opt_m) {		# Makedepend
	    print " ",$file
		unless ($file =~ m/\$/);
	} else {
	    if ($file =~ /(^.*)\/[^\/]+$/) {
		$dir = "$base/$1";
		if (! -d $dir) {
		    system("mkdir -p $dir");
		}
	    }
	    $newfile = $file;
	    $opt_l && ($newfile =~ s/$opt_l//);
	    $opt_v && print "$file => $base/$newfile\n";
	    unlink("$base/$newfile");
	    symlink("$cwd/$file", "$base/$newfile") || die "$file: $!\n";
	}
    }
}

close(FIND);

print "\n"
    if ($opt_m);
