#!/bin/sh
#
# mkprivnames
#
# This script parses message catalog entries that start with
# "privname_" into a database that maps executable names in
# /usr/sysadm/privbin/ into message catalog entries of the
# form "catalog:line-number:default".  These mappings are
# stored in /usr/sysadm/privnames/ and are used by the
# Privilege Manager (privmgr(1M)) to display nice names
# for privileged commands.

if [ $# -ne 2 ]
then
	echo usage: $0 "<msgs-include-file>" "<output>"
fi

include=$1
output=$2

grep _SGI_Mprivname $include \
	| sed -e 's/#define	_SGI_Mprivname_//' \
	      -e 's/	/:/' \
	      -e 's/\([^\\]\)"/\1/g' \
	      -e 's/\\"/"/g' > tmp.$$

if [ $? -ne 0 ]
then
	rm tmp.$$
	exit 1
fi

mv tmp.$$ $output
